// $Id: CBool.cpp,v 1.4 2007/02/08 21:06:44 paul Exp $

/*
 * All contents of this source code are copyright 2005 Exp Digital Uk.
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.
 * Certain sections of this code may come from other sources. They are credited where applicable.
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 */

#include "CBool.hpp"
using Exponent::Basics::CBool;

//	===========================================================================
EXPONENT_CLASS_IMPLEMENTATION(CBool, CCountedObject);

//	===========================================================================
CBool::CBool(const bool value) : m_value(false)
{
	EXPONENT_CLASS_CONSTRUCTION(CBool);
	this->setValue(value);
}

//	===========================================================================
CBool::~CBool()
{
	EXPONENT_CLASS_DESTRUCTION(CBool);
}

//	===========================================================================
CBool &CBool::operator = (const CBool &value)
{
	m_value = value.getValue();
	return *this;
}

//	===========================================================================
CBool &CBool::operator = (const bool value)
{
	m_value = value;
	return *this;
}

//	===========================================================================
bool CBool::operator == (const CBool &value) const
{
	return m_value == value.getValue();
}

//	===========================================================================
bool CBool::operator == (const bool value) const
{
	return m_value == value;
}

//	===========================================================================
bool CBool::operator != (const CBool &value) const
{
	return m_value != value.getValue();
}

//	===========================================================================
bool CBool::operator != (const bool value) const
{
	return m_value != value;
}

//	===========================================================================
void CBool::setValue(const CBool &value)
{
	m_value = value.getValue();
}

//	===========================================================================
void CBool::setValue(const bool value)
{
	m_value = value;
}

//	===========================================================================
bool CBool::getValue() const 
{ 
	return m_value; 
}

//	===========================================================================
CString CBool::getValueAsString() const
{
	if (m_value)
	{
		return CString("True");
	}
	return CString("False");
}

//	===========================================================================
void CBool::getValueAsString(CString &string) const
{
	if (m_value)
	{
		string = "True";
	}
	else
	{
		string = "False";
	}
}

//	===========================================================================
void CBool::getObjectDescription(char *string, const long size) const
{
	this->getValueAsString().getString(string, size);
}